#!/bin/sh

mount -t proc proc /proc
#/bin/dietsplash &

DEVICEPATH="/dev/mmcblk0p3"
KERNELPATH="/mnt/boot/bzImage"
EXTRAPARAMETER=""
KEXECCMDLINE="console=ttyS0,115200 root=$DEVICEPATH $EXTRAPARAMETER intel_idle.max_cstate=1 panic=1 consoleblank=0 vt.global_cursor_default=0 init=/sbin/init.sh rootfstype=ext4 rootwait crashkernel=64M intel_pstate=disable"
RWPATH="/dev/mmcblk0p2"

echo KEXEC kernel path: $KERNELPATH
echo KEXEC device path: $DEVICEPATH

RECOVERCONNMAN=0
RESETRW=0
mount $RWPATH /rw

if [ $? -ne 0 ]; then

    RESETRW=1
    RECOVERCONNMAN=1

fi


echo ======================================
echo ======================================
echo ======================================
echo 
echo ======================================
echo ======================================
echo ======================================

read -s -n 1 -t 1 key

if [ "${key}" == "m" ]; then

    echo Entering maintenance mode because of key press...
    rm -f /rw/firmware/go
    rm -f /rw/boot/*
    sync
    /usr/sbin/MtxSetLed-NoDrv -d 0 -c 3 -b 1
    /usr/sbin/MtxResetCtrl-NoDrv -wrd
    /usr/sbin/MtxResetCtrl-NoDrv -wrcd

    if [ "${ipv6}" == "" ]; then

        kexec --load /boot/bzImage --command-line="console=ttyS0,115200 root=/dev/mmcblk0p1 init=/sbin/init.org rootfstype=ext4 rootwait"
        kexec --exec

    else

        exec /sbin/init.org "$@"

    fi
  
fi

BOOTMM=0
INITSTATE=$(/usr/sbin/MtxResetCtrl-NoDrv | grep " is: " | cut -f2 -d':' | cut -f2 -d' ')

if [ "$INITSTATE" == "Factory" ]; then

    RESETRW=1
    
fi

if [ -f /rw/boot/resetrw ]; then

    /usr/sbin/MtxSetLed-NoDrv -d 0 -c 1 -b 3
    RESETRW=1
    
fi

if [ "$INITSTATE" == "Maintenance" ]; then

    # Extio3 change to 20 sec reset behavior, deletes firmware package unless update is in progress.
    #EXTIO3: if [ ! -f /rw/firmware/go ]; then rm -f /rw/firmware/new/* ; fi
    BOOTMM=1
  
fi

if [ -f /rw/boot/mm ]; then
  
    BOOTMM=1
  
fi

if [ "$RESETRW" == "1" ]; then

    BOOTMM=0
    /sbin/reset.sh
    
else

    rm -f /rw/firmware/validating/*
  
fi

if [ "$BOOTMM" == "1" ]; then

    echo Current boot set to maintenance mode...
    /usr/sbin/MtxSetLed-NoDrv -d 0 -c 3 -b 1
    /usr/sbin/MtxResetCtrl-NoDrv -wrd
    /usr/sbin/MtxResetCtrl-NoDrv -wrcd

    if [ "${ipv6}" == "" ]; then

        kexec --load /boot/bzImage --command-line="console=ttyS0,115200 root=/dev/mmcblk0p1 init=/sbin/init.org rootfstype=ext4 rootwait"
        kexec --exec

    else

        exec /sbin/init.org "$@"

    fi  
  
fi

mount $DEVICEPATH /mnt

if [ -f $KERNELPATH ]; then

    preinitpaniccount=0

    if [ -f /rw/boot/preinitpanic ]; then
    
        preinitpaniccount=1
    
        if [ -f /rw/boot/pipc ]; then
        
            testvar=$(cat /rw/boot/pipc)
            
            if [ $testvar -gt 0 ]; then
            
                preinitpaniccount=$((testvar+1))
                
            fi
            
        fi
        
        echo $preinitpaniccount > /rw/boot/pipc
        sync
        
    fi
    
    if [ $preinitpaniccount -gt 4 ]; then
    
        echo Entering maintenance mode because standard boot resulted in a kernel panic before the init script was executed, 5 consecutive times.
        rm -f /rw/boot/preinitpanic
        rm -f /rw/boot/pipc
    
    else
    
        touch /rw/boot/preinitpanic

        if [ -f /rw/boot/panic ]; then
            rm /rw/boot/panic
        else
            rm -f /rw/boot/rt
        fi
        
        /usr/sbin/MtxSetLed-NoDrv -d 0 -c 1 -b 2
        #/usr/bin/dietsplashctl 100 ""
        umount /rw
        kexec --load $KERNELPATH --command-line="$KEXECCMDLINE"
        umount /mnt
        umount /proc
        kexec --exec  
    
    fi
    
fi

/usr/sbin/MtxSetLed-NoDrv -d 0 -c 3 -b 1
/usr/sbin/MtxResetCtrl-NoDrv -wrd
/usr/sbin/MtxResetCtrl-NoDrv -wrcd
umount /rw
umount /mnt
mount -t proc proc /proc

if [ "${ipv6}" == "" ]; then

    kexec --load /boot/bzImage --command-line="console=ttyS0,115200 root=/dev/mmcblk0p1 init=/sbin/init.org rootfstype=ext4 rootwait"
    kexec --exec

else

    exec /sbin/init.org "$@"

fi
